import Image from 'next/image';
import React from 'react'
import Carousel from 'react-multi-carousel';
import 'react-multi-carousel/lib/styles.css';


const DolOwelcarousel = () => {
    const responsive = {
        superLargeDesktop: {
            // the naming can be any, depends on you.
            breakpoint: { max: 4000, min: 3000 },
            items: 3,
            rtl:"rtl"
        },
        desktop: {
            breakpoint: { max: 3000, min: 991 },
            items: 3,
            rtl:"rtl"
        },
        tablet: {
            breakpoint: { max: 991, min: 464 },
            items: 2,
            rtl:"rtl"
        },
        mobile: {
            breakpoint: { max: 991, min:0 },
            items: 1,
            rtl:"rtl"
        }
    };
    return (
        <>
            <div className='carousel doltestimonial-content rtl'>
                <Carousel
                className='py-4 carousel-with-dots'
                    showDots={true}
                    responsive={responsive}
                    infinite={true}
                    arrows={false} renderButtonGroupOutside={true}
                    rtl={true}
                >
                   
                   <div className="card h-100">
                        <div className='position-relative'>
                            <Image src='/assets/dol/career/doltestimonial/zainab-dawood.png' width={361} height={202} layout='responsive' className="card-img-top product--image " alt="Rectangle72" />
                            <div className='imgborder'></div>
                            <div className='bg-comas'>
                                <Image src='/assets/quotation.png'  width={100} height={10} alt='comos' />
                            </div>
                        </div>
                        <div className="card-body">
                            <p className="card-text" style={{ letterSpacing: "0px", fontWeight: "bold", fontSize: "15px", marginTop: "20px",lineHeight: "1.3" }}>ڈیسکون وسیع  تنوع  اور خواتین کو بااختیار بنانے کے عزم نے مجھے انتہائی  متاثر کیا ہے ۔ ان کے وژن کے لئے اپنا کردار ادا کرنے  پر فخر ہے۔</p>
                            <div className="card-footer">
                                <h5 className="card-title text-dark">زینب داؤد</h5>
                                <small className="text-dark fs-5">سپلائی چین <span className='mt-2 fs-6'>ڈیسکون آکسیکیم</span></small>
                            </div>
                        </div>
                    </div>
                   
                    <div className="card h-100">
                        <div className='position-relative'>
                            <Image src='/assets/dol/career/doltestimonial/mujahid-ali.png' width={361} height={202} layout='responsive' className="card-img-top product--image " alt="Rectangle72" />
                            <div className='imgborder'></div>
                            <div className='bg-comas'>
                                <Image src='/assets/quotation.png'  width={100} height={10} alt='comos' />
                            </div>
                        </div>
                        <div className="card-body">
                            <p className="card-text" style={{ letterSpacing: "0px", fontWeight: "bold", fontSize: "15px", marginTop: "20px",lineHeight: "1.3" }}>ڈیسکون: کام کی ایک بے مثال جگہ جو جدت، شمولیت، ترقی کو فروغ دینے، مثبت ثقافت، اور کمیونٹی کے پُر اثر  تعاون کے شتراک کے ساتھ اپنے امور انجام دیتی ہے ۔</p>
                            <div className="card-footer ">
                                <h5 className="card-title text-dark">مجاہد علی</h5>
                                <small className="text-dark font-weight-bold fs-5">مینٹیننس <span className='mt-2 fs-6'>ڈیسکون آکسیکیم</span></small>
                            </div>
                        </div>
                    </div>
                  
                    
                    <div className="card h-100">
                        <div className='position-relative'>
                            <Image src='/assets/dol/career/doltestimonial/muntaha-khan.png' width={361} height={202} layout='responsive' className="img-fluid card-img-top product--image " alt="Rectangle72" />
                            <div className='imgborder'></div>
                            <div className='bg-comas'>
                                <Image src='/assets/quotation.png'  width={100} height={10} alt='comos' />
                            </div>
                        </div>
                        <div className="card-body rtl">
                            <p className="card-text" style={{ letterSpacing: "0px", fontWeight: "bold", fontSize: "15px", marginTop: "20px",lineHeight: "1.3" }}>ڈیسکون کام سے بڑھ کر  بہت کچھ فراہم کرتا ہے۔ یہ ایک معاون فیملی ہے جو ترقی، فلاح و بہبود اور حقیقی دیکھ بھال کی قدر کرتا ہے۔</p>
                            <div className="card-footer">
                                <h5 className="card-title text-dark">منتہا خان</h5>
                                <small className="text-dark fs-5">انسانی وسائل <span className='mt-2 fs-6'>ڈیسکون آکسیکیم</span></small>
                            </div>
                        </div>
                    </div>
                   
                   
                  
                </Carousel>
            </div>
        </>
    )
}

export default DolOwelcarousel
