import { useState } from 'react';
import { useRouter } from 'next/router';

const Dpsgetintouch = () => {
  const [first_name, setFirst_name] = useState('');
  const [last_name, setLast_name] = useState('');
  const [email_address, setEmail_address] = useState('');
  const [phone_number, setPhone_number] = useState('');
  const [message, setMessage] = useState('');
  const [vertical, setVertical] = useState('DPS');
  const [validation, valchange] = useState(true);
  
  const [successMessage, setSuccessMessage] = useState('');
  const [errorMessage, setErrorMessage] = useState('');

  const router = useRouter();

  const handlesubmit = (e) => {
    e.preventDefault();
    const formdata = {
      first_name,
      last_name,
      email_address,
      phone_number,
      message,
      vertical,
    };

    fetch("https://www.descon.com/en/rest-api/contact/create.php", {
      method: 'POST',
      headers: { 'content-type': 'application/json' },
      body: JSON.stringify(formdata),
    })
      .then((res) => {
        setSuccessMessage('Form submitted successfully');
        setFirst_name('');
        setLast_name('');
        setEmail_address('');
        setPhone_number('');
        setMessage('');
        setVertical('DPS');
        router.push('/dps/contact-us');
      })
      .catch((err) => {
        setErrorMessage('There was an error submitting the form');
        console.log(err.message);
      });
  };

  return (
    <div className='mt-5 mb-5 contact'>
      <div className='container '>
        <div className='row'>
          <div className='col-lg-6 col-12 col-md-12 mt-5'>
            <h1 className='fw-bold text-dark '>Get in touch</h1>
            <p className='text-muted mt-3'>Our team would love to hear from you.</p>
            <form onSubmit={handlesubmit}>
              <div className='row mt-5'>
                <div className='col'>
                  <label htmlFor='exampleFormControlInput1' className='form-label'>
                    First name
                  </label>
                  <input
                    type='text'
                    required
                    value={first_name}
                    onMouseDown={(e) => valchange(true)}
                    onChange={(e) => setFirst_name(e.target.value)}
                    className='form-control form-control-lg mb-2'
                    
                    aria-label='First name'
                  />
                  {first_name === 0 && validation && <span className='text-danger'>Enter the First Name</span>}
                </div>
                <div className='col'>
                  <label htmlFor='exampleFormControlInput1' className='form-label'>
                    Last name
                  </label>
                  <input
                    type='text'
                    required
                    value={last_name}
                    onChange={(e) => setLast_name(e.target.value)}
                    className='form-control form-control-lg mb-2'
                    
                    aria-label='Last name'
                  />
                </div>
                <div className='mb-3 mt-4'>
                  <label htmlFor='exampleFormControlInput1' className='form-label'>
                    Email address
                  </label>
                  <input
                    type='email'
                    required
                    value={email_address}
                    onChange={(e) => setEmail_address(e.target.value)}
                    className='form-control form-control-lg mb-2'
                    id='exampleFormControlInput1'
                   
                  />
                </div>
                <div className='mb-3'>
                  <label htmlFor='exampleFormControlInput1' className='form-label'>
                    Phone Number
                  </label>
                  <input
                    type='number'
                    required
                    value={phone_number}
                    onChange={(e) => setPhone_number(e.target.value)}
                    className='form-control form-control-lg mb-2'
                    id='exampleFormControlInput1'
                   
                  />
                </div>
                <div className='mb-3'>
                  <label htmlFor='exampleFormControlTextarea1' className='form-label'>
                    Message
                  </label>
                  <textarea rows="6"
                    required
                    value={message}
                    onChange={(e) => setMessage(e.target.value)}
                    className='form-control form-control-lg'
                    id='exampleFormControlTextarea1'
                  ></textarea>
                </div>
                <input type='hidden' name='division' onChange={(e) => setVertical(e.target.value)} value={vertical} />
                <div className='d-grid gap-2'>
                  <label className='form-lable'></label>
                  <button type='submit' className='btn btn-primary'>
                    Submit
                  </button>
                </div>
                {errorMessage && <div className='alert alert-danger mt-4'>{errorMessage}</div>}
                                {successMessage && <div className='alert alert-success mt-4'>{successMessage}</div>}
              </div>
            </form>
          </div>
          <div className='col-lg-6 col-12 col-md-12 mt-5 pt-5'>
            <iframe
              src='https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3404.5987356049463!2d74.35571317558687!3d31.42517985183889!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x391907a9e5862e6b%3A0x291fbd885e325b4f!2sDescon%20Headquarters!5e0!3m2!1sen!2s!4v1684475763780!5m2!1sen!2s'
              title='map'
              width='100%'
              height='650'
              style={{ border: 0 }}
              allowFullScreen=''
              loading='lazy'
            ></iframe>
          </div>
        </div>
      </div>
    </div>
  );
};

export default Dpsgetintouch;

