import Image from 'next/image';
import React from 'react'
import Carousel from 'react-multi-carousel';
import 'react-multi-carousel/lib/styles.css';


const DpsOwelcarousel = () => {
    const responsive = {
        superLargeDesktop: {
            // the naming can be any, depends on you.
            breakpoint: { max: 4000, min: 3000 },
            items: 3
        },
        desktop: {
            breakpoint: { max: 3000, min: 991 },
            items: 3
        },
        tablet: {
            breakpoint: { max: 991, min: 464 },
            items: 2
        },
        mobile: {
            breakpoint: { max: 991, min:0 },
            items: 1
        }
    };
    return (
        <>
            <div className='carousel testimonial-content'>
                <Carousel
                className='py-4 carousel-with-dots'
                    showDots={true}
                    responsive={responsive}
                    infinite={true}
                    arrows={false} renderButtonGroupOutside={true}
                >
                   
                   <div className="card h-100">
                        <div className='position-relative'>
                            <Image src='/assets/dps/career/dpstestimonial/syed-aal-e-raza.png' width={361} height={202} layout='responsive' className="img-fluid card-img-top product--image " alt="Rectangle72" />
                            <div className='imgborder'></div>
                            <div className='bg-comas'>
                                <Image src='/assets/quotation.png'  width={100} height={10} alt='comos' />
                            </div>
                        </div>
                        <div className="card-body">
                            <p className="card-text" style={{ letterSpacing: "0px", fontWeight: "bold", fontSize: "15px", marginTop: "20px" }}>Since joining DPS in 2011, I’ve been proud to contribute to a market leader in O&M services for both conventional and renewable energy. DPS offers strong growth opportunities and a healthy work-life balance, making it a truly rewarding workplace.</p>
                            <div className="card-footer">
                                <h5 className="card-title text-dark">Syed Aal-e-Raza Gillani</h5>
                                <small className="text-dark">Plant Manager <span>Descon Power Solutions</span></small>
                            </div>
                        </div>
                    </div>
                    <div className="card h-100">
                        <div className='position-relative'>
                            <Image src='/assets/dps/career/dpstestimonial/umair_gull.png' width={361} height={202} layout='responsive' className="card-img-top product--image " alt="Rectangle72" />
                            <div className='imgborder'></div>
                            <div className='bg-comas'>
                                <Image src='/assets/quotation.png'  width={100} height={10} alt='comos' />
                            </div>
                        </div>
                        <div className="card-body">
                            <p className="card-text" style={{ letterSpacing: "0px", fontWeight: "bold", fontSize: "15px", marginTop: "20px" }}>My experience in DPS not only enhanced my technical skills but also improved my communication and interpersonal abilities. I am confident that the knowledge and experience I gained here have prepared me for success in my future endeavours.</p>
                            <div className="card-footer ">
                                <h5 className="card-title text-dark">Umair Gul </h5>
                                <small className="text-dark font-weight-bold">Lead Engineer QEHS <span>Descon Power Solutions</span></small>
                            </div>
                        </div>
                    </div>
                  
                    <div className="card h-100">
                        <div className='position-relative'>
                            <Image src='/assets/dps/career/dpstestimonial/muzna_wahid.png' width={361} height={202} layout='responsive' className="card-img-top product--image " alt="Rectangle72" />
                            <div className='imgborder'></div>
                            <div className='bg-comas'>
                                <Image src='/assets/quotation.png'  width={100} height={10} alt='comos' />
                            </div>
                        </div>
                        <div className="card-body">
                            <p className="card-text" style={{ letterSpacing: "0px", fontWeight: "bold", fontSize: "15px", marginTop: "20px" }}>DPS has provided me a chance to work with some of the most talented professionals of Power Industry and learn and develop my personality in line with international benchmarks. I wholeheartedly recommend DPS to anyone in need of top-notch “Operations and Maintenance” service provider and for other field services.</p>
                            <div className="card-footer">
                                <h5 className="card-title text-dark">Muzna Wahid</h5>
                                <small className="text-dark">Executive BD <span>Descon Power Solutions</span></small>
                            </div>
                        </div>
                    </div>
                   
                   
                  
                </Carousel>
            </div>
        </>
    )
}

export default DpsOwelcarousel
