import React from 'react'
import Link from 'next/link';
import Image from 'next/image';
import axios from 'axios';

const Leadership = () => {



    return (
        <>
            <div className='bg-leadership p-5 position-relative'>
                <div className='mb-5 col-md-10 mx-auto'>
                    <h1>Leadership Team</h1>
                    <p className='text-white'>Descon Engineering’s leadership team comprises competent and experienced individuals. They are responsible for conceptualizing and articulating goals that bring our people together in pursuit of set objectives. They lead the company with firm commitment to the values and vision of Descon Engineering.</p>
                </div>
                <div className="box-leadership">
                    <div className="container">
                        <div className="row align-items-center text-center bod">
                            <div className="col-lg-3 col mb-5">
                                <Link className='text-decoration-none' href='/del/leadership/taimur-saeed'>
                                    <Image src='/assets/dps/about/bod-6.jpg' alt='Toseef Ijaz Rana' className='mb-3' height={180} width={500} />
                                    <div className='m6'>
                                        <p className='fs-6 fw-bold'>Toseef Ijaz Rana</p>
                                        <p>Chief Executive Officer</p>
                                    </div>
                                </Link>
                            </div>
                            <div className="col-lg-3 col mb-5">
                                <Link className='text-decoration-none' href='/del/leadership/adnan-bakhtiar'>
                                    <Image src='/assets/dps/about/team-2.jpg' alt='Kazi Fahim Uddin' className='mb-3' height={180} width={500} />
                                    <div className='m6'>
                                        <p className='fs-6 fw-bold'>Kazi Fahim Uddin</p>
                                        <p>Head of Business Development</p>
                                    </div>
                                </Link>
                            </div>
                            <div className="col-lg-3 col mb-5">
                                <Link className='text-decoration-none' href='/del/leadership/anwar-ul-haq'>
                                    <Image src='/assets/dps/about/team-3.jpg' alt='Yasir Siddique' className='mb-3' height={180} width={500} />
                                    <div className='m6'>
                                        <p className='fs-6 fw-bold'>Yasir Siddique</p>
                                        <p>Head of Operations</p>
                                    </div>
                                </Link>
                            </div>
                            <div className="col-lg-3 col mb-5">
                                <Link className='text-decoration-none' href='/del/leadership/syed-abdul-moeed'>
                                    <Image src='/assets/dps/about/team-4.jpg' alt='Rabia Shoaib' className='mb-3' height={180} width={500} />
                                    <div className='m6'>
                                        <p className='fs-6 fw-bold'>Rabia Shoaib</p>
                                        <p>Head Finance</p>
                                    </div>
                                </Link>
                            </div>
                            <div className="col-lg-3 col mb-5">
                                <Link className='text-decoration-none' href='/del/leadership/steven-platts'>
                                    <Image src='/assets/dps/about/team-5.jpg' alt='Maaz Khawaja' className='mb-3' height={180} width={500} />
                                    <div className='m6'>
                                        <p className='fs-6 fw-bold'>Maaz Khawaja</p>
                                        <p>Head QEHS</p>
                                    </div>
                                </Link>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </>
    )
}




export default Leadership
