import React, { useEffect, useState, useRef } from 'react';
import { Tab, Nav } from 'react-bootstrap';
import { Canvas, useFrame } from '@react-three/fiber';
import { TextureLoader } from 'three';

import Ksa from '../world tabs pages/ksa';
import Pakistan from '../world tabs pages/pakistan';
import Kuwait from '../world tabs pages/kuwait';
import Iraq from '../world tabs pages/iraq';
import Qatar from '../world tabs pages/qatar';
import Oman from '../world tabs pages/oman';
import UAEgp from '../world tabs pages/uae';
import Africa from '../world tabs pages/africa';
import Azerbaijan from '../world tabs pages/azerbaijan';


const Globalpresence = () => {
  const [activeTab, setActiveTab] = useState('tab1');
  const [rotationAngle, setRotationAngle] = useState(0);
  const [currentCountry, setCurrentCountry] = useState('tab1');

  const earthTexture = '/assets/earth-texture.jpg'; 

  useEffect(() => {
    let angle = 0;
    if (activeTab === 'tab1') {
      angle = (3.1 * Math.PI) / 3;
    } else if (activeTab === 'tab2') {
      angle = (3.1 * Math.PI) / 2.6;
    } else if (activeTab === 'tab3') {
      angle = (3.1 * Math.PI) / 2.7;
    } else if (activeTab === 'tab4') {
      angle = (2.9 * Math.PI) / 2.4;
    } else if (activeTab === 'tab5') {
      angle = (3.1 * Math.PI) / 2.7;
    } else if (activeTab === 'tab6') {
      angle = (3.1 * Math.PI) / 2.6;
    } else if (activeTab === 'tab7') {
      angle = (3 * Math.PI) / 2.2;
    } else if (activeTab === 'tab8') {
      angle = (3.1 * Math.PI) / 2.7;
    }else if (activeTab === 'tab9') {
      angle = (2.9 * Math.PI) / 2.5;
    }
    setRotationAngle(angle);
  }, [activeTab]);

  const handleTabSelect = (eventKey) => {
    setCurrentCountry(eventKey);
    setActiveTab(eventKey);
  };

  const RotatingWorld = ({ rotationAngle }) => {
    const textureLoader = new TextureLoader();
    const texture = textureLoader.load(earthTexture);
    const groupRef = useRef();

    useEffect(() => {
      const pointer = document.getElementById('map-pointer');
      pointer.style.top = getPointerTopPosition(currentCountry);
      pointer.style.left = getPointerLeftPosition(currentCountry);
      pointer.style.backgroundImage = getPointerImage(currentCountry);
    }, []);

    useFrame(() => {
      groupRef.current.rotation.y = rotationAngle;
    });

    return (
      <group ref={groupRef}>
        <mesh>
          <sphereGeometry attach="geometry" args={[1, 64, 64]} />
          <meshBasicMaterial attach="material" map={texture} />
        </mesh>
      </group>
    );
  };

  const getPointerTopPosition = (country) => {
    switch (country) {
      case 'tab1':
        return '40%';
      case 'tab2':
        return '40%';
      case 'tab3':
        return '42%';
      case 'tab4':
        return '40%';
      case 'tab5':
        return '42%';
      case 'tab6':
        return '41%';
      case 'tab7':
        return '55%';
      case 'tab8':
        return '41%';      
      case 'tab9':
        return '40%';
      default:
        return '40%';
    }
  };

  const getPointerLeftPosition = (country) => {
    switch (country) {
      case 'tab1':
        return '43%';
      case 'tab2':
        return '44%';
      case 'tab3':
        return '41%';
      case 'tab4':
        return '46%';
      case 'tab5':
        return '45%';
      case 'tab6':
        return '46.5%';
      case 'tab7':
        return '48%';
      case 'tab8':
        return '44%';
        case 'tab9':
        return '45%';
      default:
        return '50%';
    }
  };

  const getPointerImage = (country) => {
    switch (country) {
      case 'tab1':
        return `url('/assets/pin1.png')`;
      case 'tab2':
        return `url('/assets/pin2.png')`;
      case 'tab3':
        return `url('/assets/pin3.png')`;
      case 'tab4':
        return `url('/assets/pin4.png')`;
      case 'tab5':
        return `url('/assets/pin5.png')`;
      case 'tab6':
        return `url('/assets/pin6.png')`;
      case 'tab7':
        return `url('/assets/pin7.png')`;
      case 'tab8':
        return `url('/assets/pin8.png')`;
        case 'tab9':
        return `url('/assets/pin9.png')`;
      default:
        return '';
    }
  };

  return (
    <div className="global-class">
      <div className="container text-center">
        <div className="mb-5 col-md-7 mx-auto">
          <h1>Global Presence</h1>
          <p className="text-muted fw-bold">
            A multinational company headquartered out of Pakistan, our presence spans multiple countries with a strong workforce from 29 different nationalities.
          </p>
        </div>
      </div>
      <div className="container mb150 minh">
        <div className="row">
          <div className="col-lg-12 col-12 col-md-12 col-sm-12 mt-5 position-relative">
            <Tab.Container activeKey={activeTab} onSelect={handleTabSelect}>
              <Nav variant="tabs" className="position-relative zindex">
                <Nav.Item>
                  <Nav.Link eventKey="tab1" id="tab1">
                    Pakistan
                  </Nav.Link>
                </Nav.Item>
                <Nav.Item>
                  <Nav.Link eventKey="tab2" id="tab2">
                    Iraq
                  </Nav.Link>
                </Nav.Item>
                <Nav.Item>
                  <Nav.Link eventKey="tab3" id="tab3">
                    KSA
                  </Nav.Link>
                </Nav.Item>
                <Nav.Item>
                  <Nav.Link eventKey="tab4" id="tab4">
                    Kuwait
                  </Nav.Link>
                </Nav.Item>
                <Nav.Item>
                  <Nav.Link eventKey="tab5" id="tab5">
                    Oman
                  </Nav.Link>
                </Nav.Item>
                <Nav.Item>
                  <Nav.Link eventKey="tab6" id="tab6">
                    Qatar
                  </Nav.Link>
                </Nav.Item>
                <Nav.Item>
                  <Nav.Link eventKey="tab7" id="tab7">
                    South Africa
                  </Nav.Link>
                </Nav.Item>
                <Nav.Item>
                  <Nav.Link eventKey="tab8" id="tab8">
                    UAE
                  </Nav.Link>
                </Nav.Item>
                 <Nav.Item>
                  <Nav.Link eventKey="tab9" id="tab9">
                    Azerbaijan
                  </Nav.Link>
                </Nav.Item>
              </Nav>
              <Tab.Content>
                <Tab.Pane eventKey="tab1" id="content1">
                  <Pakistan />
                </Tab.Pane>
                <Tab.Pane eventKey="tab2" id="content2">
                  <Iraq />
                </Tab.Pane>
                <Tab.Pane eventKey="tab3" id="content3">
                  <Ksa />
                </Tab.Pane>
                <Tab.Pane eventKey="tab4" id="content4">
                  <Kuwait />
                </Tab.Pane>
                <Tab.Pane eventKey="tab5" id="content5">
                  <Oman />
                </Tab.Pane>
                <Tab.Pane eventKey="tab6" id="content6">
                  <Qatar />
                </Tab.Pane>
                <Tab.Pane eventKey="tab7" id="content7">
                  <Africa />
                </Tab.Pane>
                <Tab.Pane eventKey="tab8" id="content8">
                  <UAEgp />
                </Tab.Pane>
                <Tab.Pane eventKey="tab9" id="content9">
                  <Azerbaijan />
                </Tab.Pane>
              </Tab.Content>
            </Tab.Container>
            {/* Rotating 3D World */}
            <div className="containerx" style={{ width: '997px', height: '1860px' }}>
              <Canvas>
                <ambientLight intensity={0.5} />
                <directionalLight intensity={0.8} position={[5, 10, 5]} />
                <RotatingWorld rotationAngle={rotationAngle} />
              </Canvas>
              <div id="map-pointer" className="map-pointer"></div>
            </div>
          </div>
        </div>
      </div>
      <div className="container-fluid">
        <div className="row">
          <div className="col-lg-12 col-12 position-relative">
            <p className="ourgeographies">OUR GEOGRAPHIES</p>
          </div>
        </div>
      </div>
    </div>
  );
};

export default Globalpresence;
