import React from 'react'
import Link from 'next/link'
import Image from 'next/image'

const Otherinitiatives = () => {
    return (
        <>
            <div className='container fullwidth p-3 spacer'>
                <div className='row '>
                    <p className='agrisubtitle'>Descon Research Farms</p>
                    <h4 className="agrititle">Other Initiatives</h4>
                    <div className='col-md-4 col-12 mb-4'>
                        <div className='card border border-primary border-2' >
                            <div className='card-image'>
                            <Link className='text-decoration-none' href='https://van.com.pk/' target="_blank">
                                <Image src='/assets/agri/agri-busniess/others-img01.png' alt="Snow" className='img-fluid' width={355} height={146} />
                                </Link>
                            </div>
                        </div>
                        <div className="card-body mt-4">
                            <h5 className="card-title fw-bold fs-6 text-dark">Vital Agri Nutrients (VAN) / Vital Green (VG)</h5>
                            <p className="card-text mt-2" style={{ lineHeight: "1.3rem" }}>VAN is an R&D driven company engaged in the production of specialty fertilizers, micronutrients, soil amendments and a range of other products aimed at making agriculture more productive and sustainable.</p>
                            <p className="card-text mt-2" style={{ lineHeight: "1.3rem" }}>The product range includes NPK blends, organic soil amendments, micronutrient blends, bio fertilizers and specialty chemicals designed for water retention in the soil. The company is committed to creating sustainable solutions for agriculture value chain through disruptive interventions.</p>
                        </div>
                    </div>

                    <div className='col-md-4 col-12 mb-4'>
                        <div className='card border border-primary border-2' >
                            <div className='card-image'>
                            <Link className='text-decoration-none' href='https://www.himalayanwellnessco.com/' target="_blank">
                                <Image src='/assets/agri/agri-busniess/others-img02.png' alt="Snow" className='img-fluid' width={355} height={146} />
                                </Link>
                            </div>
                        </div>
                        <div className="card-body mt-4">
                            <h5 className="card-title fw-bold fs-6 text-dark">Himalayan Wellness Company</h5>
                            <p className="card-text mt-2" style={{ lineHeight: "1.3rem" }}>Himalayan Wellness Company is engaged in export of Himalayan Pink Salt, related seasoning, and different ranges of quality cold pressed raw honey.
                                The Company is currently catering far east Asian markets, while expanding its presence in the Gulf and MENA regions. </p>
                        </div>
                    </div>


                    <div className='col-md-4 col-12 mb-4'>
                        <div className='card border border-primary border-2' >
                            <div className='card-image'>
                                <Image src='/assets/agri/agri-busniess/others-img03.png' alt="Snow" className='img-fluid' width={355} height={146} />

                            </div>
                        </div>
                        <div className="card-body mt-4">
                            <h5 className="card-title fw-bold fs-6 text-dark">Blume Agri</h5>
                            <p className="card-text mt-2" style={{ lineHeight: "1.3rem" }}>A state-of-the-art fruit, vegetables, spices and herbs dehydration facility being established for providing high quality dried products for local and international markets.
                                The greenfield project is expected to be operational by Aug-24</p>
                        </div>
                    </div>
                </div>
            </div>
        </>
    )
}

export default Otherinitiatives
